


<!DOCTYPE html>
<html lang="en" data-theme="dark">
    <head>
        <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-D87G9JKSWP"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-D87G9JKSWP');
</script>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Bio Shortlink</title>
	<meta name="description" content="Selamat datang di Bio Shortlink Namatin, layanan pemendek URL yang cepat dan mudah digunakan. Kami membantu Anda membuat tautan yang lebih ringkas untuk kemudahan berbagi, analitik, dan manajemen tautan. Percepat akses dengan Bio Shortlink Namatin!">
	<meta name="keywords" content="Bio Shortlink">
	<meta property="og:locale" content="en_US" />
	<meta property="og:type" content="website" />
	<meta property="og:url" content="https://hdse.shop" />
	<meta property="og:title" content="Bio Shortlink" />
	<meta property="og:description" content="Selamat datang di Bio Shortlink Namatin, layanan pemendek URL yang cepat dan mudah digunakan. Kami membantu Anda membuat tautan yang lebih ringkas untuk kemudahan berbagi, analitik, dan manajemen tautan. Percepat akses dengan Bio Shortlink Namatin!" />
	<meta property="og:site_name" content="Bio Shortlink" />
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:site" content="@">
	<meta name="twitter:title" content="Bio Shortlink">
	<meta name="twitter:description" content="Selamat datang di Bio Shortlink Namatin, layanan pemendek URL yang cepat dan mudah digunakan. Kami membantu Anda membuat tautan yang lebih ringkas untuk kemudahan berbagi, analitik, dan manajemen tautan. Percepat akses dengan Bio Shortlink Namatin!">
	<meta name="twitter:creator" content="@">
	<meta name="twitter:domain" content="https://hdse.shop">
	<link rel="icon" type="image/png" href="./content/LOGO-P.png" sizes="32x32" />
	<link rel="canonical" href="https://hdse.shop">

        <link rel="stylesheet" type="text/css" href="./static/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="./static/frontend/libs/fontawesome/all.min.css">
                <link rel="stylesheet" href="./static/style.min.css" id="stylesheet">
                <script>
            var appurl = './';
        </script>

                    </head>
    <body>
        
        <script>
function generateSessionId() {
    return '_' + Math.random().toString(36).substr(2, 9);
}
if (!localStorage.getItem('session_id')) {
    localStorage.setItem('session_id', generateSessionId());
}
fetch('/log_visit.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({
        page: window.location.href,
        referer: document.referrer,
        userAgent: navigator.userAgent,
        sessionId: localStorage.getItem('session_id')
    })
});
</script>


        <header class="py-3" id="main-header">
    <div class="container">
        <div class="navbar navbar-expand-lg py-3">
            <a href="https://hdse.shop" class="d-flex align-items-center col-md-3 text-dark text-decoration-none">
                                                <img alt="Bio Shortlink" src="./content/ids-shortlink-coapy.png" id="navbar-logo">
                                        </a>
            <button class="navbar-toggler border-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggle-icon text-secondary">
                    <span></span>
                    <span></span>
                    <span></span>
                    <span></span>
                </span>
            </button>
            <div class="collapse navbar-collapse" id="navbar">
                <ul class="nav col-12 col-md-auto mb-2 justify-content-center mb-md-0 flex-fill text-start" id="main-menu">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Solutions                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-lg-end border-0 shadow-lg end-0 rounded-3 p-3">
                            <li class="mb-2 me-0">
                                <a class="dropdown-item rounded d-flex align-items-center p-2 border-0" href="bio-profiles.html">
                                    <div class="justify-content-center icon-md bg-primary align-items-center d-flex rounded-3">
                                        <i class="fa fa-mobile gradient-primary clip-text h4 fa-fw mb-0"></i>
                                    </div>
                                    <div class="ms-3 flex-fill">
                                        <strong class="d-block">Bio Pages</strong>
                                        <small class="opacity-50 text-wrap">Convert your social media followers</small>
                                    </div>
                                </a>
                            </li>
                            <li class="me-0">
                                <a class="dropdown-item rounded d-flex align-items-center p-2 border-0" href="qr-codes.html.html">
                                    <div class="justify-content-center icon-md bg-primary align-items-center d-flex rounded-3">
                                        <i class="fa fa-qrcode gradient-primary clip-text h4 mb-0 fa-fw"></i>
                                    </div>
                                    <div class="ms-3 flex-fill">
                                        <strong class="d-block">QR Codes</strong>
                                        <small class="opacity-50 text-wrap">Customizable & trackable QR codes</small>
                                    </div>
                                </a>
                            </li>
                                                                                </ul>
                    </li>
                                                            <li class="nav-item">
                        <a class="nav-link" href="#">Blog</a>
                    </li>
                                                                                                                                                                                                                        <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Resources                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-lg-end border-0 shadow-lg end-0 rounded-3 p-3">
                                                            <li class="mb-2 me-0">
                                    <a class="dropdown-item rounded d-flex align-items-center p-2 border-0" href="./help">
                                        <div class="justify-content-center icon-md bg-primary align-items-center d-flex rounded-3">
                                            <i class="fa fa-life-ring gradient-primary clip-text h4 mb-0 fa-fw"></i>
                                        </div>
                                        <div class="ms-3 flex-fill">
                                            <strong class="d-block">Help Center</strong>
                                            <small class="opacity-50 text-wrap">Find answers to your questions</small>
                                        </div>
                                    </a>
                                </li>
                                                                                        <li class="m-0">
                                    <a class="dropdown-item rounded d-flex align-items-center p-2 border-0" href="./developers">
                                        <div class="justify-content-center icon-md bg-primary align-items-center d-flex rounded-3">
                                            <i class="fa fa-code gradient-primary clip-text h4 fa-fw mb-0"></i>
                                        </div>
                                        <div class="ms-3 flex-fill">
                                            <strong class="d-block">Developer API</strong>
                                            <small class="opacity-50 text-wrap">Guide on how to use our API</small>
                                        </div>
                                    </a>
                                </li>
                                                                                </ul>
                    </li>
                </ul>

                <div class="col-md-3 text-end flex-fill" id="login-menu">
                                                                <a href="login.html" class="btn btn-outline-primary me-3 fw-bold align-items-center">Login</a>
                                                    <a href="register.html" class="btn btn-primary fw-bold">Get Started</a>
                                                            </div>
            </div>
        </div>
    </div>
</header>
        <section id="hero" class="position-relative mt-3">
	<div class="container position-relative zindex-1">
				<div class="row g-lg-5 py-10">
			<div class="col-lg-7 text-center text-lg-start">
				<h1 class="display-4 fw-bolder my-4"><strong>Intuitive, Secure<br>& Dynamic<br> <span class="gradient-primary clip-text" data-toggle="typed" data-list="Links.,QR Codes.,Bio Pages."></span></strong></h1>
				<p class="col-lg-10 fs-5 mb-5">
					Boost your campaigns by creating dynamic Links, QR codes and Bio Pages and get instant analytics.				</p>
								<form method="post" action="./shorten" data-trigger="shorten-form" class="mt-3 mb-5 border rounded p-3 text-start">
					<div class="input-group input-group-lg align-items-center">
						<input type="text" class="form-control border-0" placeholder="Paste a long url" name="url" id="url">
						<div class="input-group-append">
														<button class="btn btn-warning d-none" type="button">Copy</button>
							<button class="btn btn-primary" type="submit">Shorten</button>
						</div>
					</div>
											<a href="#advanced" data-bs-toggle="collapse" class="btn btn-sm btn-primary mb-2 mt-2">Advanced</a>
						<div class="collapse row" id="advanced">
							<div class="col-md-6 mt-3">
								<div class="form-group">
									<label for="custom" class="control-label fw-bold mb-2">Custom</label>
									<input type="text" class="form-control p-2" name="custom" id="custom" placeholder="Type your custom alias here" autocomplete="off">
								</div>
							</div>
							<div class="col-md-6 mt-3">
								<div class="form-group">
									<label for="pass" class="control-label fw-bold mb-2">Password Protection</label>
									<input type="text" class="form-control p-2" name="pass" id="pass" placeholder="Type your password here" autocomplete="off">
								</div>
							</div>
						</div>
										<div class="h-captcha" data-sitekey="3ddef8ec-7332-4f02-aea6-736ec28a11e0" data-theme="dark" data-action="shorten"></div>
                <script src="https://www.hCaptcha.com/1/api.js?hl=en" async defer></script>
                <script>
                  var recaptcha = () => {
                    return hcaptcha.reset();
                  }
                </script>				</form>
				<div id="output-result" class="border border-success p-3 rounded d-none mb-3">
					<div class="d-flex align-items-center">
						<div id="qr-result" class="me-2"></div>
						<div id="text-result">
							<p>Your link has been successfully shortened. Want to more customization options?</p>
							<a href="./user/register" class="btn btn-sm btn-primary">Get started</a>
						</div>
					</div>
				</div>
															<a href="./user/register" class="btn btn-primary px-4 py-3 fw-bold mb-5">Get Started</a>
												</div>
			<div class="col-md-10 mx-auto col-lg-5 h-100 d-none d-sm-block position-relative">
				<div class="zindex-100 ml-lg-6">
											<img src="./static/images/shapes.svg" class="img-fluid position-absolute top-0 ms-5 end-0 w-100 h-100 animate-float opacity-50 zindex-0 outer-top">
						<div class="position-relative card shadow-0 bg-transparent p-5 border-0 perspective" style="height:500px">
							<div class="position-absolute gradient-primary w-100 top-0 start-0 opacity-75 rounded-3 h-100"></div>
							<div class="p-5 w-100 position-absolute top-50 start-50 translate-middle">
								<div class="card border-0 shadow-lg mb-3">
									<div class="card-body fs-6">
										<div class="d-flex align-items-center">
											<i class="fa fa-link fs-5"></i>
											<div class="ms-3">
												<h6 class="fw-bold mb-0">Bio</h6>
												<span class="fw-bold text-muted">https://hdse.shop/short</span>
											</div>
											<div class="ms-auto">
												<span class="fs-6 text-success">1.5M Clicks</span>
											</div>
										</div>
									</div>
								</div>
								<div class="card p-3 border-0 shadow-lg">
									<div class="d-flex align-items-center mb-0">
										<h3 class="text-dark h5 fw-bolder mb-0">
											Clicks <span class="fs-6 text-success">+50%</span>
										</h3>
										<span class="fs-6 d-block text-muted ms-auto fw-bold">1.5M Clicks</span>
									</div>
									<svg height="auto" class="rounded" viewBox="0 0 2000 1400" xmlns="http://www.w3.org/2000/svg"><path d="M0 1383.803c21-9.972 63-30.067 105-49.86s63-36.615 105-49.107c42-12.492 63 17.422 105-13.354 42-30.777 63-125.032 105-140.528 42-15.495 63 88.592 105 63.05 42-25.543 63-144.923 105-190.761 42-45.838 63-56.416 105-38.43 42 17.987 63 142.285 105 128.363 42-13.92 63-148.434 105-197.97 42-49.534 63-51.791 105-49.705 42 2.086 63 83.56 105 60.136 42-23.425 63-127.997 105-177.258 42-49.262 63-62.948 105-69.05 42-6.102 63 90.824 105 38.54s63-274.834 105-299.962c42-25.13 63 170.32 105 174.318 42 3.999 63-66.754 105-154.324 42-87.57 63-207.459 105-283.526 42-76.068 84-77.45 105-96.811L2000 1400H0Z" fill="rgba(var(--bs-primary-rgb), 1)"/><path d="M0 1383.803c21-9.972 63-30.067 105-49.86s63-36.615 105-49.107c42-12.492 63 17.422 105-13.354 42-30.777 63-125.032 105-140.528 42-15.495 63 88.592 105 63.05 42-25.543 63-144.923 105-190.761 42-45.838 63-56.416 105-38.43 42 17.987 63 142.285 105 128.363 42-13.92 63-148.434 105-197.97 42-49.534 63-51.791 105-49.705 42 2.086 63 83.56 105 60.136 42-23.425 63-127.997 105-177.258 42-49.262 63-62.948 105-69.05 42-6.102 63 90.824 105 38.54s63-274.834 105-299.962c42-25.13 63 170.32 105 174.318 42 3.999 63-66.754 105-154.324 42-87.57 63-207.459 105-283.526 42-76.068 84-77.45 105-96.811" fill="none" stroke="var(--bs-primary)" stroke-width="4"/><g fill="var(--bs-primary)" opacity="0.2"><circle cx="1575" cy="397.907" r="30"/></g><g fill="var(--bs-primary)"><circle cx="105" cy="1333.943" r="8"/><circle cx="210" cy="1284.836" r="8"/><circle cx="315" cy="1271.482" r="8"/><circle cx="420" cy="1130.954" r="8"/><circle cx="525" cy="1194.003" r="8"/><circle cx="630" cy="1003.243" r="8"/><circle cx="735" cy="964.814" r="8"/><circle cx="840" cy="1093.176" r="8"/><circle cx="945" cy="895.207" r="8"/><circle cx="1050" cy="845.501" r="8"/><circle cx="1155" cy="905.637" r="8"/><circle cx="1260" cy="728.379" r="8"/><circle cx="1365" cy="659.329" r="8"/><circle cx="1470" cy="697.869" r="8"/><circle cx="1575" cy="397.907" r="8"/><circle cx="1680" cy="572.225" r="8"/><circle cx="1785" cy="417.901" r="8"/><circle cx="1890" cy="134.375" r="8"/><text x="1480" y="300" class="fw-bold display-2">1.5K</text></g></svg>
								</div>
							</div>
							<div class="card border-0 shadow-lg mb-3 position-absolute top-0 start-0 me-5 animate-float outer-left">
								<div class="card-body">
									<div class="position-relative">
										<div class="border-0 d-block rounded p-1 d-inline-block gradient-primary text-white position-absolute top-0 start-100 translate-middle ms-3">
											<img src="data:image/svg+xml;base64,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" class="rounded">
										</div>
										<h5 class="mb-0 fw-bold me-3">QR Codes</h5>
									</div>
								</div>
							</div>
							<div class="card border-0 shadow-lg mb-3 position-absolute top-50 end-0 mt-5 animate-float outer-right">
								<div class="position-relative p-2">
									<span class="shadow-0 rounded p-2 px-3 d-inline-block gradient-primary text-white position-absolute top-0 start-50 translate-middle">
										<i class="fa fa-mobile"></i>
									</span>
									<h5 class="mb-0 mt-3 mx-3 fw-bold">Bio Pages</h5>
								</div>
							</div>
							<div class="card border-0 shadow-lg mb-3 position-absolute top-100 start-0 ms-5 animate-float outer-left">
								<div class="card-body">
									<div class="d-flex align-items-center">
										<span class="shadow-0 rounded p-2 px-3 d-inline-block gradient-primary text-white me-2">
											<i class="fa fa-link"></i>
										</span>
										<h5 class="mb-0 fw-bold">Smart Short Links</h5>
									</div>
								</div>
							</div>
						</div>
									</div>
			</div>
		</div>
	</div>
</section>
<section class="py-10 pt-5" id="features">
	<div class="container">
		<div class="row flex-lg-row-reverse align-items-center gy-5 py-5">
			<div class="col-md-6 offset-md-1 text-start">
				<span class="bg-primary py-2 px-3 rounded-pill">
					<strong class="gradient-primary clip-text fw-bolder">Collect data within minutes. Hassle-free.</strong>
				</span>
				<h2 class="display-6 fw-bold mt-3 mb-5">
					One short link, infinite possibilities.				</h2>
				<p class="lead mb-5">
					A short link is a powerful marketing tool when you use it carefully. It is not just a link but a medium between your customer and their destination. A short link allows you to collect so much data about your customers and their behaviors.				</p>
				<ul class="list-unstyled mb-2">
					<li class="mb-4">
						<div class="d-flex">
							<div>
								<strong class="icon-md bg-primary d-flex align-items-center justify-content-center rounded-3">
									<i class="fa fa-link gradient-primary clip-text fw-bolder"></i>
								</strong>
							</div>
							<div class="ms-3">
								<span class="fw-bold">Short Links</span>
								<p>Intuitive and trackable links</p>
							</div>
						</div>
					</li>
					<li class="mb-4">
						<div class="d-flex">
							<div>
								<strong class="icon-md bg-primary d-flex align-items-center justify-content-center rounded-3">
									<i class="fa fa-qrcode gradient-primary clip-text fw-bolder"></i>
								</strong>
							</div>
							<div class="ms-3">
								<span class="fw-bold">QR Codes</span>
								<p>Customizable and secure QR codes</p>
							</div>
						</div>
					</li>
					<li class="mb-4">
						<div class="d-flex">
							<div>
								<strong class="icon-md bg-primary d-flex align-items-center justify-content-center rounded-3">
									<i class="fa fa-mobile gradient-primary clip-text fw-bolder"></i>
								</strong>
							</div>
							<div class="ms-3">
								<span class="fw-bold">Beautiful Bio Pages</span>
								<p>Simple yet beautiful Bio Pages for your links</p>
							</div>
						</div>
					</li>
				</ul>
				<a href="./user/register" class="btn btn-primary px-3 py-2 fw-bold">Get Started</a>
			</div>
			<div class="col-md-5">
				<div class="p-4 p-md-5 rounded-3 shadow-sm position-relative h-100 gradient-primary">
					<h6 class="fw-bold text-white mb-2">Turn long links into short links</h6>
					<h5 class="fw-bold text-white border rounded p-3"><span data-toggle="typed" data-list="<i class='fa fa-times-circle'></i> https://longurl.com/page/article-name,<i class='fa fa-check-circle'></i> ./short"></span></h5>
					<div class="position-absolute position-sm-relative card mt-10 top-0 ms-0 ms-md-5 start-0 d-block p-5 rounded shadow w-100 opacity-90 border-0">
						<h5 class="fw-bold">Where are most of your users located?</h5>
						<div class="mt-4">
						<div class="mt-3">
							<img src="./static/images/flags/ca.svg" class="icon rounded">
							<span class="align-middle ms-2">
								Canada							</span>
							<div class="progress progress-sm mt-2">
								<div class="progress-bar" role="progressbar" style="width: 10%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
						</div>
						<div class="mt-3">
							<img src="./static/images/flags/us.svg" class="icon rounded">
							<span class="align-middle ms-2">
								United States of America							</span>
							<div class="progress progress-sm mt-2">
								<div class="progress-bar" role="progressbar" style="width: 60%" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
						</div>
						<div class="mt-3">
							<img src="./static/images/flags/gb.svg" class="icon rounded">
							<span class="align-middle ms-2">
								United Kingdom							</span>
							<div class="progress progress-sm mt-2">
								<div class="progress-bar" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
						</div>
						<div class="mt-3">
							<img src="./static/images/flags/jp.svg" class="icon rounded border">
							<span class="align-middle ms-2">
								Japan							</span>
							<div class="progress progress-sm mt-2">
								<div class="progress-bar" role="progressbar" style="width: 5%" aria-valuenow="5" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
						</div>
					</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row align-items-center gy-5 py-5 mt-8 text-start">
			<div class="col-md-6 order-last order-sm-first">
				<span class="bg-primary py-2 px-3 rounded-pill">
					<strong class="gradient-primary clip-text fw-bolder">Instantly link to apps. Automatically.</strong>
				</span>
				<h2 class="display-6 fw-bold mb-5 mt-3">
					Smart Deep Linking				</h2>
				<p class="lead mb-5">
					Grow your audience by automatically opening mobile apps when the app is installed without any coding knowledge or SDK. Direct customers to download and install apps when not installed on the device. Many popular apps are supported and you can even add your own app links.				</p>
				<a href="./user/register" class="btn btn-primary px-3 py-2 fw-bold">Get Started</a>
			</div>
			<div class="col-md-6">
				<div class="border rounded p-3 shadow-sm card position-relative">
                    <h5 class="fw-bolder mb-0"><i class="fa fa-lock text-success me-2"></i> ./<span class="gradient-primary clip-text" >smart</span></h5>
					<span class="gradient-primary d-inline-block position-absolute top-100 start-50 translate-middle text-white rounded-circle icon-sm text-center"><i class="fa fa-chevron-down mt-2 animate-float"></i></span>
                </div>
				<h3 class="h5 fw-bold mt-4 text-center">Popular Apps</h3>
				<div class="row mt-4 justify-content-center">
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Youtube" src="./static/images/youtube.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Youtube</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Amazon" src="./static/images/amazon.png" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Amazon</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Facebook" src="./static/images/facebook.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Facebook</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Instagram" src="./static/images/instagram.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Instagram</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Spotify" src="./static/images/spotify.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Spotify</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Whatsapp" src="./static/images/whatsapp.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Whatsapp</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Messenger" src="./static/images/messenger.png" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Messenger</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="TikTok" src="./static/images/tiktok.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">TikTok</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Snapchat" src="./static/images/snapchat.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Snapchat</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Apple Music" src="./static/images/itunes.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Apple Music</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Telegram" src="./static/images/telegram.png" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Telegram</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Pinterest" src="./static/images/pinterest.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Pinterest</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="LinkedIn" src="./static/images/linkedin.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">LinkedIn</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Walmart" src="./static/images/walmart.png" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Walmart</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Netflix" src="./static/images/netflix.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Netflix</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Twitch" src="./static/images/twitch.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Twitch</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Zoom" src="./static/images/zoom.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Zoom</p>
						</div>
											<div class="col-4 col-lg-2 mb-5 text-center">
							<img alt="Twitter" src="./static/images/x.svg" class="icon-md bg-white shadow-sm p-2 rounded">
							<p class="fw-bold text-dark my-3">Twitter</p>
						</div>
									</div>
			</div>
		</div>
	</div>
</section>
<section class="bg-primary py-15 text-dark">
  	<div class="container">
		<div class="text-center mb-5 px-3">
			<h2 class="fw-bolder display-5 mb-3"><strong>Features that<br>you'll <span class="gradient-primary clip-text">ever need</span></strong></h2>
			<p class="lead">We provide you with all the tools you need to increase your productivity.</p>
		</div>
		<div class="row gy-4 py-5 mt-sm-5 justify-content-center text-start">
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-spinner fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Custom Landing Page</h4>
						<p>
							Create a custom landing page to promote your product or service on forefront and engage the user in your marketing campaign.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-layer-group fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">CTA Overlays</h4>
						<p>
							Use our overlay tool to display unobtrusive notifications, polls or even a contact on the target website. Great for campaigns.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-compass fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Event Tracking</h4>
						<p>
							Add your custom pixel from providers such as Facebook and track events right when they are happening.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-bullseye fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Smart Targeting</h4>
						<p>
							Easily apply restrictions to your links and target users in specific countries & languages using specific devices.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
					<i class="fa fa-mouse-pointer fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Track Everything</h4>
						<p>
							Track users with our advanced reporting tool and know exactly which city & country your users are based.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-users fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Team Management</h4>
						<p>
							Invite your team members and assign them specific privileges to manage everything and collaborate together.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-globe fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Branded Domain Names</h4>
						<p>
							Easily add your own domain name for short links and take control of your brand name and your users' trust.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-box fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Campaigns & Channels</h4>
						<p>
							Group and organize your Links, Bio Pages and QR Codes. With Campaigns, you can also get aggregated stats.						</p>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-6 col-lg-4">
				<div class="h-100 card shadow-sm border-0">
					<div class="card-body p-4 p-sm-5">
						<i class="fa fa-terminal fa-2x gradient-primary clip-text"></i>
						<h4 class="fw-bold my-3">Developer API</h4>
						<p>
							Use our powerful API to build custom applications or extend your own application with our powerful tools.						</p>
					</div>
				</div>
			</div>
		</div>
  	</div>
</section>
<section class="py-10">
	<div class="container">
		<div class="row flex-lg-row-reverse align-items-center gy-5 py-5">
			<div class="col-md-6 order-last order-sm-first">
				<div class="card shadow border-0 p-3 mb-4 mt-5">
					<div class="d-flex">
						<img alt="New York, United States" src="./static/images/flags/fr.svg" class="avatar text-white rounded mr-3">
						<div class="ms-3 mt-2">
							<h6 class="fw-bold mb-1">Someone scanned your QR Code</h6>
							<div class="h6 mb-0 text-sm">
								<span class="text-muted">Paris, France</span>
							</div>
						</div>
						<div class="ms-auto d-none d-lg-block mt-3">
							<span class="badge badge-pill gradient-primary p-2">8 minutes ago</span>
						</div>
					</div>
				</div>
				<div class="card shadow gradient-primary border-0 p-3 mb-4">
					<div class="d-flex">
						<img alt="New York, United States" src="./static/images/flags/us.svg" class="avatar text-white rounded mr-3">
						<div class="ms-3 mt-2 text-white">
							<h6 class="fw-bold mb-1">Someone visited your Link</h6>
							<div class="h6 mb-0 text-sm">
								<span>New York, United States</span>
							</div>
						</div>
						<div class="ms-auto d-none d-lg-block mt-3">
							<span class="badge badge-pill bg-white text-dark p-2">13 minutes ago</span>
						</div>
					</div>
				</div>
				<div class="card shadow border-0 p-3 mb-4">
					<div class="d-flex">
						<img alt="New York, United States" src="./static/images/flags/gb.svg" class="avatar text-white rounded mr-3">
						<div class="ms-3 mt-2">
							<h6 class="fw-bold mb-1">Someone viewed your Bio Page</h6>
							<div class="h6 mb-0 text-sm">
								<span class="text-muted">London, United Kingdom</span>
							</div>
						</div>
						<div class="ms-auto d-none d-lg-block mt-3">
							<span class="badge badge-pill gradient-primary p-2">20 minutes ago</span>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6 order-first order-sm-last text-start">
				<span class="bg-primary py-2 px-3 rounded-pill">
					<strong class="gradient-primary clip-text fw-bolder">Get instant results</strong>
				</span>
				<h2 class="display-6 fw-bold mb-5 mt-3">
					Track & Optimize				</h2>
				<p class="lead mb-5 pe-5">
					Understanding your users and customers will help you increase your conversion. Our system allows you to track everything. Whether it is the amount of clicks, the country or the referrer, the data is there for you to analyze it.				</p>
				<a href="./user/register" class="btn btn-primary px-3 py-2 fw-bold">Get Started</a>
			</div>
		</div>
		<div class="row flex-lg-row-reverse align-items-center gy-5 py-5 mt-8 text-start">
			<div class="col-md-6 order-first order-sm-last">
				<div class="card shadow border-0 p-4 mt-5 mx-2 mx-md-4 backdrop-cards">
					<h5 class="fw-bolder">Invite People</h5>
					<span class="text-muted">Invite your teammates & work together</span>
					<div class="d-block mt-3"><strong>Members</strong> <small class="text-muted">(3/5)</small></div>
					<div class="d-flex my-2">
						<img alt="Invite your teammates & work together" src="./static/images/avatar-f1.svg" class="avatar-sm rounded-circle mr-3">
						<div class="ms-3 mt-2">
							<h6 class="fw-bold mb-1">Jane Doe</h6>
							<div class="h6 mb-0 text-sm">
								<small class="text-muted">jane.doe@bio.namatin.com</small>
							</div>
						</div>
					</div>
					<div class="d-flex my-2">
						<img alt="Invite your teammates & work together" src="./static/images/avatar-m2.svg" class="avatar-sm rounded-circle mr-3">
						<div class="ms-3 mt-2">
							<h6 class="fw-bold mb-1">Barry Tone</h6>
							<div class="h6 mb-0 text-sm">
								<small class="text-muted">barry.tone@bio.namatin.com</small>
							</div>
						</div>
						<div class="ms-auto d-none d-lg-block mt-3">
							<span class="badge badge-pill bg-primary p-2"><strong class="gradient-primary clip-text">Invited</strong></span>
						</div>
					</div>
					<div class="d-flex my-2">
						<img alt="Invite your teammates & work together" src="./static/images/avatar-m1.svg" class="avatar-sm rounded-circle mr-3">
						<div class="ms-3 mt-2">
							<h6 class="fw-bold mb-1">John Doe</h6>
							<div class="h6 mb-0 text-sm">
								<small class="text-muted">john.doe@bio.namatin.com</small>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-md-6 order-last order-sm-first">
				<span class="bg-primary py-2 px-3 rounded-pill">
					<strong class="gradient-primary clip-text fw-bolder">Collaborate with your teammates</strong>
				</span>
				<h2 class="display-6 fw-bold mb-5 mt-3">
					Invite & Work Together				</h2>
				<p class="lead mb-5">
					Invite your teammates within seconds and work together as team to manage your Links, Bio Pages and QR codes. Team members can can be assigned specific privileges and can work on different workspaces.				</p>
				<a href="./user/register" class="btn btn-primary px-3 py-2 fw-bold">Get Started</a>
			</div>
		</div>
		<div class="row mt-10">
			<div class="col-md-12">
				<div class="p-2 p-md-5 bg-primary rounded-4 border-0">
					<div class="row align-items-center">
						<div class="col-md-4 order-last order-sm-first d-none d-md-block">
							<div class="row">
								<div class="col-6 text-center">
									<div class="client mb-5">
										<img alt="Slack" src="./static/images/slack.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Slack</p>
									</div>
									<div class="client mb-5">
										<img alt="Zapier" src="./static/images/zapier.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Zapier</p>
									</div>
									<div class="client mb-5">
										<img alt="Google Tag Manager" src="./static/images/gtm.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Google Tag Manager</p>
									</div>
									<div class="client mb-5">
										<img alt="Facebook Pixels" src="./static/images/facebook.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Facebook</p>
									</div>
								</div>
								<div class="col-6 py-5 text-center">
									<div class="client mb-5">
										<img alt="Bing" src="./static/images/wp.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">WordPress</p>
									</div>
									<div class="client mb-5">
										<img alt="Bing" src="./static/images/shortcuts.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Shortcuts</p>
									</div>
									<div class="client mb-5">
										<span class="icon-md bg-white shadow-sm p-2 rounded-circle d-inline-block"><i class="fab fa-x-twitter fs-2"></i></span>
										<p class="fw-bold text-dark my-3">Twitter</p>
									</div>
									<div class="client mb-5">
										<img alt="Snapchat" src="./static/images/snapchat.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Snapchat</p>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="text-center mb-5">
								<h3 class="fw-bold mt-4"><strong>Integrations</strong></h3>
								<p>Connect your links to third-party applications so they can share information such as traffic and analytics.</p>
								<a href="./user/register" class="btn btn-primary px-3 py-2 fw-bold mt-3">Get Started</a>
							</div>
						</div>
						<div class="col-md-4 d-none d-md-block">
							<div class="row">
								<div class="col-6 py-5 text-center">
									<div class="client mb-5">
										<img alt="Bing" src="./static/images/bing.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Bing</p>
									</div>
									<div class="client mb-5">
										<img alt="Reddit" src="./static/images/reddit.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Reddit</p>
									</div>
									<div class="client mb-5">
										<img alt="Google Analytics" src="./static/images/ga.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Google Analytics</p>
									</div>
									<div class="client mb-5">
										<img alt="LinkedIn" src="./static/images/linkedin.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">LinkedIn</p>
									</div>
								</div>
								<div class="col-6 text-center">
									<div class="client mb-5">
										<img alt="Pinterest" src="./static/images/pinterest.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Pinterest</p>
									</div>
									<div class="client mb-5">
										<img alt="Quora" src="./static/images/quora.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Quora</p>
									</div>
									<div class="client mb-5">
										<img alt="TikTok" src="./static/images/tiktok.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">TikTok</p>
									</div>
									<div class="client mb-5">
										<img alt="Adroll" src="./static/images/aroll.svg" class="icon-md bg-white shadow-sm p-2 rounded-circle">
										<p class="fw-bold text-dark my-3">Adroll</p>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row mt-5 text-start">
						<div class="col-md-6 mb-2 mb-md-0">
							<div class="h-100 card shadow-sm border-0">
								<div class="card-body p-4 p-sm-5">
									<i class="fa fa-th fa-2x gradient-primary clip-text"></i>
									<h4 class="fw-bold my-3">Tracking Pixels</h4>
									<p>
										Add your custom pixel from providers such as Facebook & Google Tag Manager and track events right when they are happening.									</p>
								</div>
							</div>
						</div>
						<div class="col-md-6 mb-0">
							<div class="h-100 card shadow-sm border-0">
								<div class="card-body p-4 p-sm-5">
									<i class="fa fa-bell fa-2x gradient-primary clip-text"></i>
									<h4 class="fw-bold my-3">Notifications</h4>
									<p>
										Get notified when users use your links via various channels such Slack and webhook services like Zapier.									</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
	<section class="py-8">
        <div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<h2 class="fw-bolder display-5 mb-5 text-center text-md-start"><strong>Let <br><span class="gradient-primary clip-text">the numbers</span><br> do the talking.</strong></h2>
				</div>
				<div class="col-lg-6">
					<div class="row">
						<div class="col-md-6 mb-5">
							<div class="text-center bg-primary py-5 px-2 px-lg-5 rounded">
								<h3 class="h5 text-capitalize"><span class="gradient-primary fw-bolder clip-text">Powering</span></h3>
								<div class="h1">
									<span class="counter">492</span>
									<span class="counter-extra">+</span>
								</div>
								<h3 class="h6 text-capitalize fw-bold">Links</h3>
							</div>
						</div>
						<div class="col-md-6 mb-5">
							<div class="text-center bg-primary py-5 px-2 px-lg-5 rounded">
								<h3 class="h5 text-capitalize"><span class="gradient-primary fw-bolder clip-text">Serving</span></h3>
								<div class="h1">
									<span class="counter">1696982</span>
									<span class="counter-extra">+</span>
								</div>
								<h3 class="h6 text-capitalize fw-bold">Clicks</h3>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-6 mb-5">
							<div class="text-center bg-primary py-5 px-2 px-lg-5 rounded">
								<h3 class="h5 text-capitalize"><span class="gradient-primary fw-bolder clip-text">Trusted by</span></h3>
								<div class="h1">
									<span class="counter">431</span>
									<span class="counter-extra">+</span>
								</div>
								<h3 class="h6 text-capitalize fw-bold">Amazing Customers</h3>
							</div>
						</div>
						<div class="col-md-6 mb-5 d-none d-md-block">
							<a href="./user/register">
								<div class="bg-primary py-5 px-2 px-lg-5 rounded h-100 d-flex align-items-center justify-content-center">
									<h3 class="h5 text-capitalize">
										<span class="gradient-primary fw-bolder clip-text">Get Started <i class="fa fa-chevron-right small"></i></span>
									</h3>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
        </div>
    </section>
<section class="py-5">
	<div class="container">
		<div class="h-100 p-5 gradient-primary text-white with-shapes rounded-4 border-0 text-start">
			<div class="row align-items-center gy-lg-5">
				<div class="col-sm-8">
					<h2 class="fw-bold">Take control of your links</h2>
					<p>You are one click away from taking control of all of your links, and instantly get better results.</p>
				</div>
				<div class="col-sm-4 text-end">
					<a class="btn btn-light text-primary btn-lg d-block d-sm-inline-block" href="./user/register">Get Started</a>
				</div>
			</div>
		</div>
	</div>
</section>

        <footer class="pt-5 text-start" id="footer-main">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 mb-5 mb-lg-0" class="text-dark">
                <a href="https://hdse.shop">
                                                            <img alt="Bio Shortlink" src="./content/ids-shortlink-coapy.png" id="navbar-logo">
                                                    </a>
                <p class="mt-4">Selamat datang di Bio Shortlink Namatin, layanan pemendek URL yang cepat dan mudah digunakan. Kami membantu Anda membuat tautan yang lebih ringkas untuk kemudahan berbagi, analitik, dan manajemen tautan. Percepat akses dengan Bio Shortlink Namatin!</p>
                <ul class="nav mt-4">
                                                                                                </ul>
            </div>
            <div class="col-lg-4 col-6 col-sm-6 ml-lg-auto mb-5 mb-lg-0">
                <h6 class="fw-bold mb-3">Solutions</h6>
                <ul class="list-unstyled">
                    <li class="mb-2"><a class="nav-link" href="./qr-codes.html">QR Codes</a></li>
                    <li class="mb-2"><a class="nav-link" href="./bio-profiles">Bio Pages</a></li>
                                                                                
                </ul>
            </div>
            <div class="col-lg-4 col-6 col-sm-6 mb-5 mb-lg-0">
                <h6 class="fw-bold mb-3">Resources</h6>
                <ul class="list-unstyled">
                                        
                                            <li class="mb-2"><a class="nav-link" href="./help">Help Center</a></li>
                                                                <li class="mb-2"><a class="nav-link" href="./developers">Developer API</a></li>
                                                                                    <li class="mb-2"><a class="nav-link" href="./contact">Contact Us</a></li>
                                    </ul>
            </div>
        </div>
        <div class="row align-items-center justify-content-md-between pb-2 mt-5">
            <div class="col-md-4">
                <div class="copyright text-sm text-center text-md-start">
                    &copy; 2025 <a href="https://hdse.shop" class="fw-bold">Bio Shortlink</a>. All Rights Reserved                </div>
            </div>
            <div class="col-md-8">
                <ul class="nav justify-content-center justify-content-md-end mt-3 mt-md-0">
                                                                                    <li class="nav-item"><a class="nav-link text-dark" href="./report">Report</a></li>
                                                                            </ul>
            </div>
        </div>
    </div>
</footer>
        <a class="position-fixed bottom-0 end-0 m-3 btn btn-dark rounded-circle shadow opacity-0" role="button" data-trigger="scrollto" data-top="0" id="scroll-to-top">
            <i class="fa fa-chevron-up small" aria-hidden="true"></i>
        </a>

        <script type="text/javascript">
    var lang = {"error":"Please enter a valid URL.","couponinvalid":"The coupon enter is not valid","minurl":"You must select at least 1 url.","minsearch":"Keyword must be more than 3 characters!","nodata":"No data is available for this request.","datepicker":{"7d":"Last 7 Days","3d":"Last 30 Days","tm":"This Month","lm":"Last Month"},"cookie":{"title":"Cookie Preferences","description":"This website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. You have the option to choose which one to allow.","button":" <button type=\"button\" data-cc=\"c-settings\" class=\"cc-link\" aria-haspopup=\"dialog\">Let me choose<\/button>","accept_all":"Accept All","accept_necessary":"Accept Necessary","close":"Close","save":"Save Settings","necessary":{"title":"Strictly Necessary Cookies","description":"These cookies are required for the correct functioning of our service and without these cookies you will not be able to use our product."},"analytics":{"title":"Targeting and Analytics","description":"Providers such as Google use these cookies to measure and provide us with analytics on how you interact with our website. All of the data is anonymized and cannot be used to identify you."},"ads":{"title":"Advertisement","description":"These cookies are set by our advertisers so they can provide you with relevant ads."},"extra":{"title":"Additional Functionality","description":"We use various providers to enhance our products and they may or may not set cookies. Enhancement can include Content Delivery Networks, Google Fonts, etc"},"privacy":{"title":"Privacy Policy","description":"You can view our privacy policy <a target=\"_blank\" class=\"cc-link\" href=\"https:\/\/bio.namatin.com\/page\/privacy\">here<\/a>. If you have any questions, please do not hesitate to <a href=\"https:\/\/bio.namatin.com\/contact\" target=\"_blank\" class=\"cc-link\">Contact us<\/a>"}}}</script>
        <script src="./static/webpack.pack.js"></script>
                	<script src="./static/frontend/libs/clipboard/dist/clipboard.min.js"></script>
	<script src="./static/frontend/libs/typedjs/typed.min.js"></script>
        
        
        <script src="./static/app.min.js?v=1.0"></script>
        <script src="./static/server.min.js?v=1.2"></script>
                			
		            </body>

</html>