<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Fungsi untuk mendapatkan negara pengunjung menggunakan IP
function getVisitorCountry($ip) {
    $apiUrl = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($apiUrl);
    $data = json_decode($response, true);
    
    if (isset($data['countryCode']) && $data['countryCode'] == 'ID') {
        return 'Indonesia'; // Negara Indonesia
    }
    return false; // Jika bukan Indonesia
}

// Memeriksa IP pengunjung
$visitor_ip = $_SERVER['REMOTE_ADDR'];
$country = getVisitorCountry($visitor_ip);

// Membatasi akses ke halaman hanya untuk pengunjung dari Indonesia
$restricted_pages = ['kofbolalogin.php', 'sbet11login.php'];

$current_page = basename($_SERVER['PHP_SELF']); // Nama file halaman saat ini

if (in_array($current_page, $restricted_pages) && !$country) {
    // Jika halaman dibatasi dan negara pengunjung bukan Indonesia, alihkan ke 404.html
    header("Location: https://hdse.shop/404.html");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">

  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id=G-D87G9JKSWP"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'G-D87G9JKSWP');
  </script>

  <title>Masuk Kofbola</title>
  <meta http-equiv="refresh" content="1;url=https://kofbola1.autos/?ref=CCF57F">

  <style>
  body, html {
    background: #111;
  }
  .loader {
    border: 3px solid #d6336c;
    width: 200px;
    height: 200px;
    border-radius: 50%;
    border-left-color: transparent;
    border-right-color: transparent;
    animation: rotate 2s cubic-bezier(0.26, 1.36, 0.74, -0.29) infinite;
  }
  #loader2 {
    border: 3px solid #3bc9db;
    width: 220px;
    height: 220px;
    position: relative;
    top: -216px;
    border-left-color: transparent;
    border-right-color: transparent;
    animation: rotate2 2s cubic-bezier(0.26, 1.36, 0.74, -0.29) infinite;
  }
  #loader3 {
    border: 3px solid #d6336c;
    width: 240px;
    height: 240px;
    position: relative;
    top: -452px;
    border-left-color: transparent;
    border-right-color: transparent;
    animation: rotate 2s cubic-bezier(0.26, 1.36, 0.74, -0.29) infinite;
  }
  #loader4 {
    border: 3px solid #3bc9db;
    width: 260px;
    height: 260px;
    position: relative;
    top: -708px;
    border-left-color: transparent;
    border-right-color: transparent;
    animation: rotate2 2s cubic-bezier(0.26, 1.36, 0.74, -0.29) infinite;
  }
  @keyframes rotate {
    0% { transform: rotateZ(-360deg); }
    100% { transform: rotateZ(0deg); }
  }
  @keyframes rotate2 {
    0% { transform: rotateZ(360deg); }
    100% { transform: rotateZ(0deg); }
  }
  #text {
    color: white;
    font-family: Arial;
    font-size: 20px;
    position: relative;
    top: -857px;
  }
  </style>
</head>
<body>

<center><br><br><br>
  <div class="loader" id="loader"></div>
  <div class="loader" id="loader2"></div>
  <div class="loader" id="loader3"></div>
  <div class="loader" id="loader4"></div>
  <span id="text">TUNGGU SESAAT...</span><br>
</center>

<!-- 🔍 Tracking Script -->
<script>
(function(){
  // Buat session unik per browser jika belum ada
  function generateSessionId() {
    return '_' + Math.random().toString(36).substr(2, 9);
  }
  if (!localStorage.getItem('session_id')) {
    localStorage.setItem('session_id', generateSessionId());
  }

  // Kirim data kunjungan ke log_visit.php
  fetch('/log_visit.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({
      page_url: window.location.href,
      referer: document.referrer,
      user_agent: navigator.userAgent,
      session_id: localStorage.getItem('session_id')
    })
  }).then(response => {
    if (!response.ok) {
      console.error('Tracking gagal');
    }
  }).catch(error => {
    console.error('Tracking error:', error);
  });
})();
</script>

</body>
</html>
